/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.craftbukkit.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventoryCustom;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class CraftCustomInventory
implements InventoryHolder {
    private final CraftInventory container;

    public CraftCustomInventory(Container inventory) {
        this.container = new CraftInventory(inventory);
    }

    public CraftCustomInventory(ItemStackHandler handler) {
        this.container = new CraftInventoryCustom((InventoryHolder)this, handler.getStacks());
    }

    @Nullable
    public static InventoryHolder getHolder(IItemHandler handler) {
        if (handler == null) {
            return null;
        }
        if (handler instanceof ItemStackHandler) {
            return new CraftCustomInventory((ItemStackHandler)handler);
        }
        if (handler instanceof SlotItemHandler) {
            return new CraftCustomInventory(((SlotItemHandler)((Object)handler)).f_40218_);
        }
        if (handler instanceof InvWrapper) {
            return new CraftCustomInventory(((InvWrapper)handler).getInv());
        }
        if (handler instanceof SidedInvWrapper) {
            return new CraftCustomInventory(((SidedInvWrapper)handler).getInventory());
        }
        if (handler instanceof PlayerInvWrapper) {
            IItemHandlerModifiable[] playerInventoryWrapper;
            for (IItemHandlerModifiable itemHandler : playerInventoryWrapper = (IItemHandlerModifiable[])ObfuscationReflectionHelper.getPrivateValue(CombinedInvWrapper.class, (Object)((PlayerInvWrapper)handler), (String)"itemHandler")) {
                if (itemHandler instanceof PlayerMainInvWrapper) {
                    return new CraftCustomInventory((Container)((PlayerMainInvWrapper)itemHandler).getInventoryPlayer());
                }
                if (!(itemHandler instanceof PlayerArmorInvWrapper)) continue;
                return new CraftCustomInventory((Container)((PlayerArmorInvWrapper)itemHandler).getInventoryPlayer());
            }
        }
        return null;
    }

    @Nullable
    public static Inventory getCustomInventory(IItemHandler handler) {
        InventoryHolder holder = CraftCustomInventory.getHolder(handler);
        return holder != null ? holder.getInventory() : null;
    }

    @Override
    public Inventory getInventory() {
        return this.container;
    }

    public static List<HumanEntity> getViewers(Container inventory) {
        try {
            return inventory.getViewers();
        }
        catch (AbstractMethodError e) {
            return new ArrayList<HumanEntity>();
        }
    }
}

